using System;
using System.IO;

public class Program
{
  public static void Main(String[] args)
  {
    if(args.Length < 1)
    {
      Console.WriteLine("Wywołanie programu: Program plik");
      return;
    }
    String plik = args[0];

    BinaryReader br;
    try
    {
      br = new BinaryReader(new FileStream(plik, FileMode.Open));
    }
    catch(Exception)
    {
      Console.WriteLine("Otwarcie pliku {0} nie powiodło się.", plik);
      return;
    }

    try
    {
      Console.WriteLine("Wartości odczytane z pliku {0}: ", plik);
      int ile = br.ReadInt32();
      for(int i = 0; i < ile; i++)
      {
        int wartosc = br.ReadInt32();
        Console.Write(wartosc + " ");
      }
      br.Close();
    }
    catch(Exception)
    {
      Console.WriteLine("Wystąpił błąd w trakcie odczytu danych.");
      return;
    }
  }
}
